C HISTOGRAM FOR DRNOR
C
      DOUBLE PRECISION A,B
      PARAMETER(NBINS=32,A=-3.0D0,B=3.0D0)
      INTEGER ISEED,I,J,H(NBINS),NR,INBIN
      DOUBLE PRECISION  R,DRNOR,DSTART,RSEED,WIDTH
C
      ISEED = 305
      RSEED = DSTART(ISEED)
      WIDTH=(B-A)/(NBINS-2)
CCCCCC  100 WRITE (*,*) 'EX 10.1: ENTER NUMBER OF NORMALS : '
      DO 200 I = 1,NBINS
          H(I)=0
  200 CONTINUE
CCCCC      READ (*,*) NR
      WRITE (*,*) 'RUNNING 10,000 NORMALS INTO 32 BINS...'
      NR = 10000
      IF (NR .LE. 0) STOP
      DO 1 I = 1,NR 
          R = DRNOR()
          J = INBIN(A,B,NBINS,WIDTH,R)
          H(J) = H(J)+1
    1 CONTINUE
C
      WRITE (*,*) 'HISTOGRAM FOR DRNOR: NUMBER IN BIN 1,...,32'
      WRITE (*,*) '   (-INFINITY,-3],(-3,-2.8],...,(2.8,3],(3,INFINITY)'
      WRITE (*,*) ' (VALUES ARE SLIGHTLY COMPUTER DEPENDENT)'
      WRITE (*,'(9I8)') (H(I),I=1,NBINS)
C
      WRITE (*,*)
      WRITE (*,*)
     *   'REFERENCE RESULTS FROM IBM PC/AT '
      WRITE(*,*)'     16      14      21      32      46      96     135
     *      198     292'
      WRITE(*,*)'    334     454     549     611     665     743     801
     *      785     751'
      WRITE(*,*)'    747     634     503     421     351     274     184
     *      124      90'
      WRITE(*,*)'     53      35      19      13       9'
      STOP
      END 
C
      INTEGER FUNCTION INBIN (XMIN,XMAX,NBINS,WIDTH,DATA)
C
C THIS FUNCTION TAKES A DOUBLE PRECISION VALUE IN DATA, AND FINDS
C THE CORRECT BIN FOR IT.  VALES BELOW XMIN COME BACK
C IN 1.  VALUES ABOVE XMAX COME BACK IN NBINS.
C
      INTEGER NBINS 
      DOUBLE PRECISION XMIN,XMAX,WIDTH,DATA
      IF (DATA .LT. XMIN) THEN
         INBIN = 1
      ELSE IF (DATA .GE. XMAX) THEN
         INBIN = NBINS
      ELSE
         INBIN = 2 + (DATA-XMIN)/WIDTH
      ENDIF
      RETURN
      END 
